package gov.va.med.mhv.admin.model;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.hibernate.annotations.Type;
@Entity
@Table(name="EMPLOYEE_ORG_ROLE_HISTORY")
public class EmployeeOrgRoleHistory implements Serializable{

	private static final long serialVersionUID = 24116501003463860L;
	
	@Id
	@Column(name="EMPLOYEE_ORG_ROLE_HISTORY_ID")
	@GeneratedValue(strategy=GenerationType.AUTO)
	private Long id;
	
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="MODIFICATION_DATE")
	private Date modificationDate;
	
	@Column(name="OPLOCK")
	private Integer oplock;

	
	@Column(name="ROLE_ACTION")
	private String roleAction;
	
	@ManyToOne
	@JoinColumn(name="EMPLOYEE_ID")
	private Employee performingEmployee;
	
	@ManyToOne
	@JoinColumn(name="EMPLOYEE_ORG_ROLE_ID")
	private EmployeeOrgRole employeeOrgRole;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Date getModificationDate() {
		return modificationDate;
	}

	public void setModificationDate(Date modificationDate) {
		this.modificationDate = modificationDate;
	}

	public String getRoleAction() {
		return roleAction;
	}

	public void setRoleAction(String roleAction) {
		this.roleAction = roleAction;
	}

	public EmployeeOrgRole getEmployeeOrgRole() {
		return employeeOrgRole;
	}

	public void setEmployeeOrgRole(EmployeeOrgRole employeeOrgRole) {
		this.employeeOrgRole = employeeOrgRole;
	}

	public Employee getPerformingEmployee() {
		return performingEmployee;
	}

	public void setPerformingEmployee(Employee performingEmployee) {
		this.performingEmployee = performingEmployee;
	}


}
